<?php

namespace Database\Seeders;

use App\Models\SiteConfiguration;
use App\Models\SiteConfigurationGroup;
use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SiteConfigurationsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('site_configuration_groups')->truncate();
        $site_configuration_groups = [
            'general', 'layout', 'logos', 'mail_configurations', 'language_settings', 'payments_settings', 'social_settings', 'seo_information'
        ];
        foreach ($site_configuration_groups as $value) {
            DB::table('site_configuration_groups')->insert([
                'title' => $value,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]);
        }
        $general_group_id = SiteConfigurationGroup::GENERAL_GROUP;
        $layout_group_id = SiteConfigurationGroup::LAYOUT_GROUP;
        $logos_group_id = SiteConfigurationGroup::LOGO_GROUP;
        $mail_configurations_group_id = SiteConfigurationGroup::MAIL_SETTINGS_GROUP;
        $language_group_id = SiteConfigurationGroup::LANGUAGE_GROUP;
        $payment_group_id = SiteConfigurationGroup::PAYMENT_SETTINGS_GROUP;
        $social_group_id = SiteConfigurationGroup::SOCIAL_SETTINGS_GROUP;
        $seo_information_group_id = SiteConfigurationGroup::SEO_INFO_GROUP;

        DB::table('site_configuration')->truncate();
        $site_configurations = [
            /*Site Contact Information*/
            [
                'identifier' => 'app.name',
                'identifier_key' => 'app_name',
                'config_group_id' => $general_group_id,
                'configuration_title' => "App Name",
                'configuration_value' => config('app.name'),
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'app.url',
                'identifier_key' => 'app_url',
                'config_group_id' => $general_group_id,
                'configuration_title' => "APP URL",
                'configuration_value' => config('app.url'),
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'app.address',
                'identifier_key' => 'app_address',
                'config_group_id' => $general_group_id,
                'configuration_title' => "APP address",
                'configuration_value' => 'TITANIUM SQUARE, Cross Roads, Jai Ambe Nagar, Thaltej, Ahmedabad, Gujarat 380054',
                'control_type' => 'textarea',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'contact_email',
                'identifier_key' => 'contact_email',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Contact Email',
                'configuration_value' => 'help@powerlms.org',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'contact_no',
                'identifier_key' => 'contact_no',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Contact Number',
                'configuration_value' => '+91 99099 61835',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'facebook_link',
                'identifier_key' => 'facebook_link',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Facebook Link',
                'configuration_value' => 'https://www.facebook.com/profile.php?id=100087663507008',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'youtube_link',
                'identifier_key' => 'youtube_link',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Youtube Link',
                'configuration_value' => 'https://www.youtube.com/',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'instagram_link',
                'identifier_key' => 'instagram_link',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Instagram Link',
                'configuration_value' => 'https://www.instagram.com/powerlms/',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'linkedin_link',
                'identifier_key' => 'linkedin_link',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Linkedin Link',
                'configuration_value' => 'https://www.linkedin.com/company/powerlms-learning-management-system',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'twitter_link',
                'identifier_key' => 'twitter_link',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Twitter Link',
                'configuration_value' => 'https://twitter.com/PowerLms',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'telegram_link',
                'identifier_key' => 'telegram_link',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Telegram Link',
                'configuration_value' => null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'system_revenue_percentage',
                'identifier_key' => 'system_revenue_percentage',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'System Revenue (%)',
                'configuration_value' => 5,
                'control_type' => 'number',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'tax_value_percentage',
                'identifier_key' => 'tax_value_percentage',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Tax Value (%)',
                'configuration_value' => 10,
                'control_type' => 'number',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'enable_instructor_application_review',
                'identifier_key' => 'enable_instructor_application_review',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Enable Instructor Application Review',
                'configuration_value' => 1,
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'enable_course_review',
                'identifier_key' => 'enable_course_review',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Enable Course Review',
                'configuration_value' => 1,
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'disable_instructor_registration',
                'identifier_key' => 'disable_instructor_registration',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Disable Instructor Registration',
                'configuration_value' => 0,
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'google_map_link',
                'identifier_key' => 'google_map_link',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Google Map Link',
                'configuration_value' => 'https://www.google.co.in/maps/place/PowerLMS+-+Learning+Management+System/@23.051139,72.5167024,17z/data=!3m1!4b1!4m5!3m4!1s0x395e9be05d86bb93:0xd23c92dce9e9b777!8m2!3d23.0511341!4d72.5188911?hl=en&authuser=0',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'location_iframe',
                'identifier_key' => 'location_iframe',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Location Iframe Code',
                'configuration_value' => '<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3671.2542370261745!2d72.51670241542355!3d23.05113902104329!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x395e9be05d86bb93%3A0xd23c92dce9e9b777!2sPowerLMS%20-%20Learning%20Management%20System!5e0!3m2!1sen!2sin!4v1673588263648!5m2!1sen!2sin" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>',
                'control_type' => 'textarea',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.no-captcha.active',
                'identifier_key' => 'services_no_captcha_active',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Captcha Status',
                'configuration_value' => config('services.no-captcha.active'),
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => 'google_recaptcha_credentials',
                'documentation_redirect_url' => 'https://support.google.com/analytics/answer/1042508',
            ],
            [
                'identifier' => 'no-captcha.sitekey',
                'identifier_key' => 'no_captcha_sitekey',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Captcha Key',
                'configuration_value' => !empty(config('no-captcha.sitekey')) ? config('no-captcha.sitekey') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.no-captcha.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'no-captcha.secret',
                'identifier_key' => 'no_captcha_secret',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Captcha Secret',
                'configuration_value' => !empty(config('no-captcha.secret')) ? config('no-captcha.secret') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.no-captcha.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'rights_company_name',
                'identifier_key' => 'rights_company_name',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Rights Company Name',
                'configuration_value' => 'Urvam Technologies Pvt. Ltd.',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'rights_company_website_url',
                'identifier_key' => 'rights_company_website_url',
                'config_group_id' => $general_group_id,
                'configuration_title' => 'Rights Company Website URL',
                'configuration_value' => 'https://www.urvam.com/',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            /*Layout*/
            [
                'identifier' => 'front_home_layout',
                'identifier_key' => 'front_home_layout',
                'config_group_id' => $layout_group_id,
                'configuration_title' => 'Layout',
                'configuration_value' => 'layout1',
                'control_type' => 'select_box',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'layout_sections',
                'identifier_key' => 'layout_sections',
                'config_group_id' => 0,
                'configuration_title' => 'Layout Sections',
                'configuration_value' => json_encode(SiteConfiguration::SECTIONS['layout1']),
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            /*Logo & Icons*/
            [
                'identifier' => 'logo',
                'identifier_key' => 'logo',
                'config_group_id' => $logos_group_id,
                'configuration_title' => 'Front Dark Logo',
                'configuration_value' => 'default-logo.png',
                'control_type' => 'file',
                'note' => 'logo',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'logo_white',
                'identifier_key' => 'logo_white',
                'config_group_id' => $logos_group_id,
                'configuration_title' => 'Front White Logo',
                'configuration_value' => 'default-logo-white.png',
                'control_type' => 'file',
                'note' => 'logo_white',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'admin_logo',
                'identifier_key' => 'admin_logo',
                'config_group_id' => $logos_group_id,
                'configuration_title' => 'Admin Logo',
                'configuration_value' => 'default-admin-logo.png',
                'control_type' => 'file',
                'note' => 'admin_logo',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'favicon_icon',
                'identifier_key' => 'favicon_icon',
                'config_group_id' => $logos_group_id,
                'configuration_title' => 'Add Favicon Icon',
                'configuration_value' => 'default-favicon.png',
                'control_type' => 'file',
                'note' => 'favicon_icon',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'certificate_background_image',
                'identifier_key' => 'certificate_background_image',
                'config_group_id' => $logos_group_id,
                'configuration_title' => 'Certificate Background Image',
                'configuration_value' => 'default-certificate-background.png',
                'control_type' => 'file',
                'note' => 'certificate_background_image',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'certificate_signature_image',
                'identifier_key' => 'certificate_signature_image',
                'config_group_id' => $logos_group_id,
                'configuration_title' => 'Certificate Signature Image',
                'configuration_value' => 'default-certificate-sign.jpg',
                'control_type' => 'file',
                'note' => 'certificate_signature_image',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],

            /*Mail Configurations*/
            [
                'identifier' => 'mail.from.name',
                'identifier_key' => 'mail_from_name',
                'config_group_id' => $mail_configurations_group_id,
                'configuration_title' => 'Mail From Name',
                'configuration_value' => !empty(config('mail.from.name')) ? config('mail.from.name') : null,
                'control_type' => 'text',
                'note' => 'mail_from_name',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'mail.from.address',
                'identifier_key' => 'mail_from_address',
                'config_group_id' => $mail_configurations_group_id,
                'configuration_title' => 'Mail From Address',
                'configuration_value' => !empty(config('mail.from.address')) ? config('mail.from.address') : null,
                'control_type' => 'text',
                'note' => 'mail_from_address',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'mail.default',
                'identifier_key' => 'mail_default',
                'config_group_id' => $mail_configurations_group_id,
                'configuration_title' => 'Mail Driver',
                'configuration_value' => !empty(config('mail.default')) ? config('mail.default') : null,
                'control_type' => 'text',
                'note' => 'mail_default',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'mail.mailers.smtp.host',
                'identifier_key' => 'mail_mailers_smtp_host',
                'config_group_id' => $mail_configurations_group_id,
                'configuration_title' => 'Mail HOST',
                'configuration_value' => !empty(config('mail.mailers.smtp.host')) ? config('mail.mailers.smtp.host') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'mail.mailers.smtp.port',
                'identifier_key' => 'mail_mailers_smtp_port',
                'config_group_id' => $mail_configurations_group_id,
                'configuration_title' => 'Mail PORT',
                'configuration_value' => !empty(config('mail.mailers.smtp.port')) ? config('mail.mailers.smtp.port') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'mail.mailers.smtp.username',
                'identifier_key' => 'mail_mailers_smtp_username',
                'config_group_id' => $mail_configurations_group_id,
                'configuration_title' => 'Mail Username',
                'configuration_value' => !empty(config('mail.mailers.smtp.username')) ? config('mail.mailers.smtp.username') : null,
                'control_type' => 'text',
                'note' => 'mail_mailers_smtp_username',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'mail.mailers.smtp.password',
                'identifier_key' => 'mail_mailers_smtp_password',
                'config_group_id' => $mail_configurations_group_id,
                'configuration_title' => 'Mail Password',
                'configuration_value' => !empty(config('mail.mailers.smtp.password')) ? config('mail.mailers.smtp.password') : null,
                'control_type' => 'password',
                'note' => 'mail_mailers_smtp_password',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'mail.mailers.smtp.encryption',
                'identifier_key' => 'mail_mailers_smtp_encryption',
                'config_group_id' => $mail_configurations_group_id,
                'configuration_title' => 'Mail Encryption',
                'configuration_value' => !empty(config('mail.mailers.smtp.encryption')) ? config('mail.mailers.smtp.encryption') : null,
                'control_type' => 'select_box',
                'note' => 'mail_mailers_smtp_encryption',
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],

            /*Language Settings*/
            [
                'identifier' => 'app.locale',
                'identifier_key' => 'app_locale',
                'config_group_id' => $language_group_id,
                'configuration_title' => 'Default Language',
                'configuration_value' => 'en',
                'control_type' => 'select_box',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            /*Payment Settings*/
            [
                'identifier' => 'app.currency',
                'identifier_key' => 'app_currency',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Select Currency',
                'configuration_value' => config('app.currency'),
                'control_type' => 'select_box',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'currency_position',
                'identifier_key' => 'currency_position',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Currency Position',
                'configuration_value' => 'left',
                'control_type' => 'select_box',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.stripe.active',
                'identifier_key' => 'services_stripe_active',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Stripe Payment Method',
                'configuration_value' => config('services.stripe.active'),
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => 'stripe_api_credentials',
                'documentation_redirect_url' => 'https://stripe.com/docs/keys',
            ],
            [
                'identifier' => 'services.stripe.key',
                'identifier_key' => 'services_stripe_key',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'API Key',
                'configuration_value' => !empty(config('services.stripe.key')) ? config('services.stripe.key') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.stripe.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.stripe.secret',
                'identifier_key' => 'services_stripe_secret',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'API Secret',
                'configuration_value' => !empty(config('services.stripe.secret')) ? config('services.stripe.secret') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.stripe.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.razorpay.active',
                'identifier_key' => 'services_razorpay_active',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Razorpay Payment Method',
                'configuration_value' => config('services.razorpay.active'),
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => 'razorpay_api_credentials',
                'documentation_redirect_url' => 'https://dashboard.razorpay.com/',
            ],
            [
                'identifier' => 'services.razorpay.key',
                'identifier_key' => 'services_razorpay_key',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'API Key',
                'configuration_value' => !empty(config('services.razorpay.key')) ? config('services.razorpay.key') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.razorpay.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.razorpay.secret',
                'identifier_key' => 'services_razorpay_secret',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'API Secret',
                'configuration_value' => !empty(config('services.razorpay.secret')) ? config('services.razorpay.secret') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.razorpay.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.paypal.active',
                'identifier_key' => 'services_paypal_active',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Paypal Payment Method',
                'configuration_value' => config('services.paypal.active'),
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => 'paypal_api_credentials',
                'documentation_redirect_url' => 'https://developer.paypal.com/developer/applications/',
            ],
            [
                'identifier' => 'paypal.settings.mode',
                'identifier_key' => 'paypal_settings_mode',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Mode',
                'configuration_value' => !empty(config('paypal.settings.mode')) ? config('paypal.settings.mode') : null,
                'control_type' => 'select_box',
                'note' => 'paypal_settings_mode',
                'parent_config_identifier' => 'services.paypal.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'paypal.client_id',
                'identifier_key' => 'paypal_client_id',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Client ID',
                'configuration_value' => !empty(config('paypal.client_id')) ? config('paypal.client_id') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.paypal.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'paypal.secret',
                'identifier_key' => 'paypal_secret',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Secret',
                'configuration_value' => !empty(config('paypal.secret')) ? config('paypal.secret') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.paypal.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.payu.active',
                'identifier_key' => 'services_payu_active',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'PayUMoney Payment Method',
                'configuration_value' => config('services.payu.active'),
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => 'payumoney_api_credentials',
                'documentation_redirect_url' => 'https://www.payumoney.com/merchant-dashboard/#/integration',
            ],
            [
                'identifier' => 'services.payu.mode',
                'identifier_key' => 'services_payu_mode',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Mode',
                'configuration_value' => !empty(config('services.payu.mode')) ? config('services.payu.mode') : null,
                'control_type' => 'select_box',
                'note' => 'services_payu_mode',
                'parent_config_identifier' => 'services.payu.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.payu.key',
                'identifier_key' => 'services_payu_key',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'API Key',
                'configuration_value' => !empty(config('services.payu.key')) ? config('services.payu.key') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.payu.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.payu.salt',
                'identifier_key' => 'services_payu_salt',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Salt',
                'configuration_value' => !empty(config('services.payu.salt')) ? config('services.payu.salt') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.payu.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'offline_payment.active',
                'identifier_key' => 'offline_payment_active',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Offline Payment Method',
                'configuration_value' => 1,
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'offline_payment.instruction',
                'identifier_key' => 'payment_offline_instruction',
                'config_group_id' => $payment_group_id,
                'configuration_title' => 'Offline Payment Instructions',
                'configuration_value' => null,
                'control_type' => 'textarea',
                'note' => null,
                'parent_config_identifier' => 'offline_payment.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            /*Social Settings*/
            [
                'identifier' => 'services.facebook.active',
                'identifier_key' => 'services_facebook_active',
                'config_group_id' => $social_group_id,
                'configuration_title' => 'Facebook Login Status',
                'configuration_value' => config('services.facebook.active'),
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => 'facebook_api_credentials',
                'documentation_redirect_url' => 'https://developers.facebook.com/apps/',
            ],
            [
                'identifier' => 'services.facebook.client_id',
                'identifier_key' => 'services_facebook_client_id',
                'config_group_id' => $social_group_id,
                'configuration_title' => 'Client ID',
                'configuration_value' => !empty(config('services.facebook.client_id')) ? config('services.facebook.client_id') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.facebook.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.facebook.client_secret',
                'identifier_key' => 'services_facebook_client_secret',
                'config_group_id' => $social_group_id,
                'configuration_title' => 'Client Secret',
                'configuration_value' => !empty(config('services.facebook.client_secret')) ? config('services.facebook.client_secret') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.facebook.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.facebook.redirect',
                'identifier_key' => 'services_facebook_redirect',
                'config_group_id' => $social_group_id,
                'configuration_title' => 'Redirect URL',
                'configuration_value' => !empty(config('services.facebook.redirect')) ? config('services.facebook.redirect') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.facebook.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.google.active',
                'identifier_key' => 'services_google_active',
                'config_group_id' => $social_group_id,
                'configuration_title' => 'Google Login Status',
                'configuration_value' => config('services.google.active'),
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => 'google_api_credentials',
                'documentation_redirect_url' => 'https://console.developers.google.com/apis',
            ],
            [
                'identifier' => 'services.google.client_id',
                'identifier_key' => 'services_google_client_id',
                'config_group_id' => $social_group_id,
                'configuration_title' => 'Client ID',
                'configuration_value' => !empty(config('services.google.client_id')) ? config('services.google.client_id') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.google.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.google.client_secret',
                'identifier_key' => 'services_google_client_secret',
                'config_group_id' => $social_group_id,
                'configuration_title' => 'Client Secret',
                'configuration_value' => !empty(config('services.google.client_secret')) ? config('services.google.client_secret') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.google.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'services.google.redirect',
                'identifier_key' => 'services_google_redirect',
                'config_group_id' => $social_group_id,
                'configuration_title' => 'Redirect URL',
                'configuration_value' => !empty(config('services.google.redirect')) ? config('services.google.redirect') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => 'services.google.active',
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'meta_title',
                'identifier_key' => 'meta_title',
                'config_group_id' => $seo_information_group_id,
                'configuration_title' => 'General Meta Title',
                'configuration_value' => 'PowerLMS - Education & Courses',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'meta_description',
                'identifier_key' => 'meta_description',
                'config_group_id' => $seo_information_group_id,
                'configuration_title' => 'General Meta Description',
                'configuration_value' => 'PowerLMS - Education & Courses Landing Page Template',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'meta_keywords',
                'identifier_key' => 'meta_keywords',
                'config_group_id' => $seo_information_group_id,
                'configuration_title' => 'General Meta Keywords',
                'configuration_value' => 'Responsive, HTML5 Template, Jthemes, Courses, Education, Learning, Online Education, Study',
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'google_tag_manager_code',
                'identifier_key' => 'google_tag_manager_code',
                'config_group_id' => $seo_information_group_id,
                'configuration_title' => 'Google Tag Manager Code',
                'configuration_value' => !empty(config('services.google.tag_manager_code')) ? config('services.google.tag_manager_code') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            //BackUp Configurations
            [
                'identifier' => 'backup.status',
                'identifier_key' => 'backup_status',
                'config_group_id' => 0,
                'configuration_title' => 'Backup Status',
                'configuration_value' => 0,
                'control_type' => 'checkbox',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'backup.notifications.mail.to',
                'identifier_key' => 'backup_notification_email',
                'config_group_id' => 0,
                'configuration_title' => 'Email Notification',
                'configuration_value' => !empty(config('backup.notifications.mail.to')) ? config('backup.notifications.mail.to') : null,
                'control_type' => 'text',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'backup.content',
                'identifier_key' => 'backup_content',
                'config_group_id' => 0,
                'configuration_title' => 'Backup Files',
                'configuration_value' => !empty(config('backup.content')) ? config('backup.content') : null,
                'control_type' => 'radio',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
            [
                'identifier' => 'backup.schedule',
                'identifier_key' => 'backup_schedule',
                'config_group_id' => 0,
                'configuration_title' => 'Backup Schedule',
                'configuration_value' => !empty(config('backup.schedule')) ? config('backup.schedule') : null,
                'control_type' => 'select_box',
                'note' => null,
                'parent_config_identifier' => null,
                'documentation_redirect_text' => null,
                'documentation_redirect_url' => null,
            ],
        ];
        foreach ($site_configurations as $site_configuration) {
            if (isset($site_configuration['parent_config_identifier'])) {
                $config = SiteConfiguration::where('identifier', $site_configuration['parent_config_identifier'])->first();
                $site_configuration['parent_config_id'] = $config['id'];
            }
            unset($site_configuration['parent_config_identifier']);
            DB::table('site_configuration')->insert($site_configuration);
        }
    }
}
